IF OBJECT_ID('P_CADASTRAR_META') IS NOT NULL
BEGIN
	DROP PROCEDURE P_CADASTRAR_META
END

GO

CREATE PROCEDURE P_CADASTRAR_META (@SOBREPORMETA INT, @CD_USU INT)
AS BEGIN


DECLARE @CD_META_FILIAL INT
DECLARE @CD_FILIAL INT
DECLARE @MES_META INT
DECLARE @ANO_META INT

DECLARE @VLR_VD MONEY
DECLARE @VLR_DESC MONEY
DECLARE @QTDE_CUPONS MONEY
DECLARE @IT_CLI MONEY
DECLARE @LUCRATIVIDADE MONEY

SET NOCOUNT ON

IF @SOBREPORMETA = 1
BEGIN
	UPDATE 
		MA 
	SET  
		MA.VLR_VD = MN.VLR_VD, 
		MA.VLR_DESC = MN.VLR_DESC, 
		MA.QTDE_CUPONS = MN.QTDE_CUPONS, 
		MA.QTDE_ITENS = MN.QTDE_ITENS
	FROM 
		#EST_META_FILIAL_CPL MN 
		INNER JOIN EST_META_FILIAL_CPL MA ON
			MA.CD_EMP =  1
			AND MN.CD_FILIAL = MA.CD_FILIAL
			AND MN.DT_META = MA.DT_META
END

DECLARE 
	CURSOR_META
CURSOR FOR
	SELECT
		CD_FILIAL,
		MONTH(DT_META) AS MES_META,
		YEAR(DT_META) AS ANO_META,
		SUM(VLR_VD) AS VLR_VD,
		SUM(VLR_DESC) AS VLR_DESC,
		SUM(QTDE_CUPONS) AS QTDE_CUPONS,
		SUM(QTDE_ITENS) AS IT_CLI,
		MAX(LUCRATIVIDADE) AS LUCRATIVIDADE
	FROM
		#EST_META_FILIAL_CPL
	GROUP BY
		CD_FILIAL,
		MONTH(DT_META),
		YEAR(DT_META)
		
OPEN CURSOR_META

FETCH NEXT FROM CURSOR_META INTO @CD_FILIAL, @MES_META, @ANO_META, @VLR_VD, @VLR_DESC, @QTDE_CUPONS, @IT_CLI, @LUCRATIVIDADE


WHILE @@FETCH_STATUS = 0
BEGIN

	SET @CD_META_FILIAL = COALESCE((SELECT CD_META_FILIAL FROM EST_META_FILIAL WHERE CD_EMP = 1 AND CD_FILIAL = @CD_FILIAL AND MES_META = @MES_META AND ANO_META = @ANO_META), 0)

	IF @CD_META_FILIAL = 0 
	BEGIN
		SET @CD_META_FILIAL = COALESCE((SELECT MAX(CD_META_FILIAL) FROM EST_META_FILIAL WHERE CD_EMP = 1), 0) + 1
		INSERT INTO 
			EST_META_FILIAL (CD_EMP, CD_META_FILIAL, CD_FILIAL, DS_META, MES_META, ANO_META, VLR_VD, VLR_DESC, QTDE_CUPONS, IT_CLI, CD_USU, DT_CAD, PERC_LUCRATIVIDADE)
		VALUES
			(1, @CD_META_FILIAL, @CD_FILIAL, 'IMPORTACAO DE META POR ARQUIVO', @MES_META, @ANO_META, @VLR_VD, @VLR_DESC, @QTDE_CUPONS, @IT_CLI, @CD_USU, CONVERT(DATE, GETDATE()), @LUCRATIVIDADE)
	END


	INSERT INTO
		EST_META_FILIAL_CPL (CD_EMP, CD_FILIAL, CD_META_FILIAL, DT_META, VLR_VD, VLR_DESC, QTDE_CUPONS, QTDE_ITENS)
	SELECT
		1 AS CD_EMP,
		CD_FILIAL,
		@CD_META_FILIAL,
		DT_META,
		MAX(VLR_VD),
		MAX(VLR_DESC), 
		MAX(QTDE_CUPONS), 
		MAX(QTDE_ITENS)
	FROM
		#EST_META_FILIAL_CPL
	WHERE
		CD_FILIAL = @CD_FILIAL
		AND MONTH(DT_META) = @MES_META
		AND YEAR(DT_META) = @ANO_META
		AND NOT EXISTS (
			SELECT
				*
			FROM
				EST_META_FILIAL_CPL
			WHERE
				CD_EMP = 1
				AND CD_FILIAL = #EST_META_FILIAL_CPL.CD_FILIAL
				AND DT_META = #EST_META_FILIAL_CPL.DT_META)
	GROUP BY
		CD_FILIAL,
		DT_META


	FETCH NEXT FROM CURSOR_META INTO @CD_FILIAL, @MES_META, @ANO_META, @VLR_VD, @VLR_DESC, @QTDE_CUPONS, @IT_CLI, @LUCRATIVIDADE
END


UPDATE
	M
SET
	M.VLR_VD = MCPL.VLR_VD,
	M.VLR_DESC = MCPL.VLR_DESC,
	M.QTDE_CUPONS = MCPL.QTDE_CUPONS,
	M.IT_CLI = MCPL.QTDE_ITENS,
	M.PERC_LUCRATIVIDADE = MCPL.LUCRATIVIDADE
FROM
	EST_META_FILIAL M
	INNER JOIN 
		(SELECT
			MCPL.CD_EMP,
			MCPL.CD_FILIAL,
			MCPL.CD_META_FILIAL,
			SUM(MCPL.VLR_VD) AS VLR_VD,
			SUM(MCPL.VLR_DESC) AS VLR_DESC,
			SUM(MCPL.QTDE_CUPONS) AS QTDE_CUPONS,
			SUM(MCPL.QTDE_ITENS) AS QTDE_ITENS,
			MAX(MCPL2.LUCRATIVIDADE) AS LUCRATIVIDADE
		FROM
			EST_META_FILIAL_CPL MCPL
			INNER JOIN #EST_META_FILIAL_CPL MCPL2 ON
				MCPL.CD_FILIAL = MCPL2.CD_FILIAL
				AND MCPL.DT_META = MCPL2.DT_META
		GROUP BY
			MCPL.CD_EMP,
			MCPL.CD_FILIAL,
			MCPL.CD_META_FILIAL) MCPL ON
		M.CD_EMP = MCPL.CD_EMP
		AND M.CD_FILIAL = MCPL.CD_FILIAL
		AND M.CD_META_FILIAL = MCPL.CD_META_FILIAL
	
		


CLOSE CURSOR_META
DEALLOCATE CURSOR_META

SET NOCOUNT OFF

END
